% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{RRIcore}
\alias{RRIcore}
\alias{RRIcore.numeric}
\alias{RRIcore.SpatRaster}
\title{RRIcore: RRI using only the four inner second order directional differences of the RRI kernel}
\usage{
RRIcore(x, ...)

\method{RRIcore}{numeric}(x, ...)

\method{RRIcore}{SpatRaster}(x, ..., .method = c("rcpp", "r"))
}
\arguments{
\item{x}{A DEM/image as a SpatRaster or a vector of numeric values from a focal window in a DEM from which to compute the index}

\item{...}{reserved for future use}

\item{.method}{Either \code{r} or \code{rcpp} (fast batch processing using C++)}
}
\value{
RRIcore (in the same units of input)
}
\description{
RRIcore is like RRI, but it just uses the four inner second order directional differences, using a
3x3 kernel. There are some analogies with Casorati curvature.
The input is the DEM/image (no need to detrend).
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
roughRRIcore=RRIcore(dem)
plot(roughRRIcore)
}
\references{
Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology,
\doi{doi:10.1016/j.geomorph.2023.108838}.
}
