% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAM.R
\name{SAM}
\alias{SAM}
\title{SAM}
\usage{
SAM(
  lower = NULL,
  upper = NULL,
  minLS = NULL,
  maxLS = NULL,
  constraint = 1,
  digits = 2,
  plot = FALSE,
  res = 1,
  lower_percentile = 2.5,
  upper_percentile = 97.5,
  length_units = NULL
)
}
\arguments{
\item{lower}{Numeric (length 1). Lower percentile of catch length (e.g., 2.5th).}

\item{upper}{Numeric (length 1). Upper percentile of catch length (e.g., 97.5th).}

\item{minLS}{Numeric (length 1). Minimum landing size (must be > 0).}

\item{maxLS}{Numeric (length 1). Maximum landing size (must be > 0).}

\item{constraint}{Numeric (length 1) in \eqn{[0,1]}. Cap applied \emph{when either}
slot limit is violated (default = 1).}

\item{digits}{Integer. Number of decimal places used to round outputs
(default = 2). Set \code{digits = NA} to prevent rounding.}

\item{plot}{Logical. If \code{TRUE}, include a \pkg{ggplot2} plot of the calculated value
on a grid of (\code{lower}, \code{upper}) combinations (default \code{FALSE}).}

\item{res}{Numeric > 0. Grid step for plotting when \code{plot = TRUE}. Smaller
values increase smoothness but can be slower (default \code{1}).}

\item{lower_percentile, upper_percentile}{Numbers used only for axis labels when
\code{plot = TRUE} (defaults \code{2.5} and \code{97.5}).}

\item{length_units}{Optional character scalar. Units to display in the x/y-axis
labels when \code{plot = TRUE} (e.g., \code{"cm"} or \code{"mm"}). If \code{NULL} (default),
units are omitted.}
}
\value{
A list with:
\describe{
\item{lower_adherence}{Relative deviation of \code{lower} from \code{minLS}: \eqn{(lower - minLS)/minLS}.}
\item{upper_adherence}{Relative deviation of \code{upper} from \code{maxLS}: \eqn{(maxLS - upper)/maxLS}.}
\item{SAM}{Size adherence multiplier. \code{SAM > 1} increases the advised catch; \code{SAM < 1} decreases it.}
\item{plot}{(only when \code{plot = TRUE}) a \pkg{ggplot2} object visualizing SAM over a grid.
Illogical combinations of percentiles are shaded grey (e.g., \eqn{L_{2.5} > L_{97.5}}).}
}
}
\description{
Calculate the size adherence multiplier (SAM), which evaluates adherence to
harvest slot limits by comparing (\code{lower}, \code{upper}) percentiles of length–frequency
data to \code{minLS} and \code{maxLS}. Optionally, produce a graph showing
how SAM varies across a grid of (\code{lower}, \code{upper}) values.

When \code{lower >= minLS} and \code{upper <= maxLS}, neither of the slot
limits are violated and the multiplier is calculated without constraint.
When \code{lower < minLS} or \code{upper > maxLS}, at least one slot limit is
violated and the multiplier is capped at \code{constraint} (default = 1).
}
\details{
The unconstrained multiplier is \eqn{(1 + lower\_adherence) \times (1 + upper\_adherence)}.
If any slot limit is violated, the multiplier is \code{pmin(constraint, multiplier)}.
}
\examples{
SAM(lower = 13, upper = 24, minLS = 12, maxLS = 24)                      # no violation
SAM(lower = 13, upper = 25, minLS = 12, maxLS = 24, constraint = 0.95)   # violation with constraint

\donttest{
out <- SAM(
  lower = 13, upper = 25,
  minLS = 12, maxLS = 24,
  res = 0.5,
  lower_percentile = 5, upper_percentile = 95,
  constraint = 1,
  plot = TRUE,
  length_units = "cm")
out$SAM
}

}
\seealso{
\code{\link{percentile}} for computing percentiles from length–frequency data.
}
