% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb.R
\name{tb}
\alias{tb}
\title{Frequency and Summary Tables}
\usage{
tb(
  data,
  ...,
  m = FALSE,
  d = 1,
  format = TRUE,
  style = "n_pct",
  style.rp = "{rp} ({lower} - {upper})",
  style.or = "{or} ({lower} - {upper})",
  test = FALSE,
  subset = NULL,
  strat = NULL,
  rp = FALSE,
  or = FALSE,
  ref = NULL,
  conf.level = 0.95,
  var.type = NULL,
  stat.cont = "median"
)
}
\arguments{
\item{data}{A data.frame or atomic vector.}

\item{...}{Variables to be tabulated. Can include variable names and/or flags
(m, p, row, col, rp, or) for controlling output format.}

\item{m}{Logical. If TRUE, includes missing values (NA) in the table. Default: FALSE.}

\item{d}{Integer. Number of decimal places for percentages and statistics. Default: 1.}

\item{format}{Logical. If TRUE, renders a formatted grid output (Stata-style).
If FALSE, prints as simple matrix. Default: TRUE.}

\item{style}{Character. Format for displaying counts and percentages. Options:
\itemize{
\item \code{"n_pct"}: "100 (25.0\\%)" (default)
\item \code{"pct_n"}: "25.0\\% (100)"
\item Custom template using \code{{n}} and \code{{p}} placeholders, e.g., \code{"{n} [{p}\%]"}.
}}

\item{style.rp}{Character. Format string for Prevalence Ratio. Default: \code{"{rp} ({lower} - {upper})"}.}

\item{style.or}{Character. Format string for Odds Ratio. Default: \code{"{or} ({lower} - {upper})"}.}

\item{test}{Logical or Character. Performs statistical test on 2x2+ tables.
\itemize{
\item \code{TRUE}: Automatic selection (chi-squared for categorical)
\item \code{"chisq"}, \code{"fisher"}, \code{"mcnemar"}
}}

\item{subset}{Logical expression for row filtering.}

\item{strat}{Variable for column stratification. Disables PR/OR calculations.}

\item{rp}{Logical. If TRUE, calculates Prevalence Ratios (PR).}

\item{or}{Logical. If TRUE, calculates Odds Ratios (OR).}

\item{ref}{Character or numeric. Specifies the reference level for PR/OR calculations.}

\item{conf.level}{Numeric. Confidence level for intervals (0-1). Default: 0.95.}

\item{var.type}{Named character vector specifying variable types.
\itemize{
\item Select the line variable and choose between "continuous" and "cont".
\item Example: \code{tb(epitabl, age, sex, var.type = c(age = "continuous"))}
}}

\item{stat.cont}{Character. "mean" (Mean/SD) or "median" (Median/IQR).}
}
\value{
An object of class \code{tb} which is a matrix with attributes containing
statistics, formatted flags, and class information.
}
\description{
Creates comprehensive tables for categorical or continuous variables with formatting,
statistical tests, prevalence ratios (PR), odds ratios (OR), and column stratification.
Supports both univariate and bivariate analysis with flexible output formatting.
}
