% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_agreement_assurance.R
\name{agree_assurance}
\alias{agree_assurance}
\title{Assurance Probability for Limits of Agreement}
\usage{
agree_assurance(
  conf.level = 0.95,
  assurance = 0.9,
  omega = NULL,
  pstar = 0.95,
  sigma = 1,
  n = NULL
)
}
\arguments{
\item{conf.level}{confidence level for the range of agreement (1 - alpha).
The confidence level of the confidence interval of the range of agreement
(tolerance interval). Default is 0.95.}

\item{assurance}{target lower bound of the assurance probability (1 - gamma).
The assurance probability is the probability that the study half-width will
be less than omega. Common values are 0.80, 0.90, or 0.95.}

\item{omega}{upper bound of assurance half-width. The sample size guarantees
(assures) that 100(1 - gamma)\% of interval half-widths will be less than
this value. Can be specified in standard deviation units.}

\item{pstar}{central proportion of the data distribution covered (P*). It is
the proportion of observations that fall between the limits. For example, a
value of 0.95 indicates that 95\% of the variable's values fall between the
limits. Must be between 0 and 1. Common values are 0.90 or 0.95.}

\item{sigma}{population standard deviation of the paired differences. If the
true value is unknown, omega can be specified in standard deviation units
by setting sigma = 1.}

\item{n}{sample size (optional). If provided, the function will solve for a
different parameter rather than sample size.}
}
\value{
An object of class \code{"power.htest"} containing the following components:
\itemize{
\item \code{n}: The required sample size (number of subject pairs)
\item \code{conf.level}: The confidence level (1 - alpha)
\item \code{assurance}: The target assurance probability (1 - gamma)
\item \code{actual.assurance}: The actual assurance probability achieved (may differ
slightly from target due to discrete nature of n)
\item \code{omega}: The upper bound of assurance half-width
\item \code{pstar}: The central proportion covered (P*)
\item \code{sigma}: The population standard deviation
\item \code{g.factor}: The Odeh-Owen factor (g'') used to construct the tolerance
interval, tabulated in Odeh and Owen (1980)
\item \code{method}: Description of the method used
\item \code{note}: Additional notes about the analysis
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
}
\details{
Calculate the sample size necessary for a confidence interval of the Bland-Altman
range of agreement when the underlying data distribution is normal. This function
uses the assurance probability criterion to determine the optimum sample size,
based on the exact confidence interval method of Jan and Shieh (2018), which has
been shown to be superior to approximate methods.
\subsection{Overview}{

This function implements the exact method for determining sample size based on
assurance probability for Bland-Altman limits of agreement, as described in
Jan and Shieh (2018). The assurance probability criterion determines an N that
guarantees with specified probability (1 - gamma) that the confidence interval
half-width will be no more than a boundary value omega.
}

\subsection{Technical Details}{

Suppose a study involves paired differences (X - Y) whose distribution is
approximately N(mu, sigma^2). The range of agreement is defined as a confidence
interval of the central portion of these differences, specifically the area
between the 100(1-p)th and 100p-th percentiles, where p* = 2p - 1.

The exact two-sided, 100(1 - alpha)\% confidence interval for the range of
agreement is defined as:

Pr(theta_(1-p) < theta_hat_(1-p) and theta_hat_p < theta_p) = 1 - alpha

The equal-tailed tolerance interval recommended by Jan and Shieh (2018) is:

(X_bar - d, X_bar + d)

where d = g * S, g is the Odeh-Owen tolerance factor (tabulated as g'' in
Odeh and Owen (1980)), and S is the sample
standard deviation.
}

\subsection{Sample Size Determination}{

The sample size N is selected to satisfy: Pr(H <= omega) >= 1 - gamma

This leads to the expression:

psi(eta) >= 1 - gamma

where psi() is the CDF of a chi-square distribution with N-1 degrees of
freedom and eta = (N-1) \* (omega/(g\*sigma))^2.

The method uses equal-tailed tolerance intervals based on the noncentral
t-distribution to construct exact confidence intervals for the range of
agreement. The tolerance factor g is calculated such that the interval
maintains the specified confidence level under normality.

Jan and Shieh (2018) demonstrated through extensive simulations that this
exact method should be adopted rather than the classical Bland-Altman
approximate method.
}

\subsection{Interpreting Results}{

Each subject produces two measurements (one for each method being compared).
The sample size n returned is the number of subject pairs needed. The actual
assurance probability may differ slightly from the target due to the discrete
nature of sample size.

For dropout considerations, inflate the sample size using: N' = N / (1 - dropout_rate),
always rounding up.
}
}
\section{Assumptions}{

\itemize{
\item The paired differences are normally distributed
\item The variance is constant across the range of measurement
\item Pairs are independent
}
}

\examples{
# Example: Planning a method comparison study
# Researchers want 95\% confidence, 90\% assurance that half-width
# will be within 2.5 SD units, covering central 95\% of differences
agree_assurance(
  conf.level = 0.95,
  assurance = 0.90,
  omega = 2.5,
  pstar = 0.95,
  sigma = 1
)
}
\references{
Jan, S.L. and Shieh, G. (2018). The Bland-Altman range of agreement: Exact
interval procedure and sample size determination. \emph{Computers in Biology and Medicine}, \strong{100},
247-252. \doi{10.1016/j.compbiomed.2018.06.020}

Odeh, R.E. and Owen, D.B. (1980). \emph{Tables for Normal Tolerance Limits,
Sampling Plans, and Screening}. Marcel Dekker, Inc., New York.
}
\seealso{
\code{\link[=agree_expected_half]{agree_expected_half()}} for sample size determination using expected
half-width criterion, \code{\link[=power_agreement_exact]{power_agreement_exact()}} for power analysis
of agreement tests.
}
