% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n.R
\name{n_nodes}
\alias{n_nodes}
\alias{n_nodes,SimInf_model-method}
\alias{n_nodes,SimInf_pfilter-method}
\alias{n_nodes,SimInf_pmcmc-method}
\title{Determine the number of nodes in a model}
\usage{
n_nodes(model)

\S4method{n_nodes}{SimInf_model}(model)

\S4method{n_nodes}{SimInf_pfilter}(model)

\S4method{n_nodes}{SimInf_pmcmc}(model)
}
\arguments{
\item{model}{the \code{model} object to extract the number of
nodes from.}
}
\value{
the number of nodes in the model.
}
\description{
Determine the number of nodes in a model
}
\examples{
## Create an 'SIR' model with 100 nodes, with 99 susceptible,
## 1 infected and 0 recovered in each node.
u0 <- data.frame(S = rep(99, 100), I = rep(1, 100), R = rep(0, 100))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Display the number of nodes in the model.
n_nodes(model)
}
