% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_beta.R
\name{sb_beta}
\alias{sb_beta}
\title{SelectBoost for beta-regression models}
\usage{
sb_beta(
  X,
  Y = NULL,
  selector = betareg_step_aic,
  corrfunc = "cor",
  B = 100,
  step.num = 0.1,
  steps.seq = NULL,
  version = c("glmnet", "lars"),
  squeeze = TRUE,
  use.parallel = FALSE,
  seed = NULL,
  verbose = FALSE,
  threshold = 1e-04,
  interval = c("none", "uniform", "midpoint"),
  Y_low = NULL,
  Y_high = NULL,
  ...
)
}
\arguments{
\item{X}{Numeric design matrix. Coerced with \code{\link[=as.matrix]{as.matrix()}} and normalised via
\code{\link[=sb_normalize]{sb_normalize()}}.}

\item{Y}{Numeric response vector. Values are squeezed to the open unit
interval with the standard SelectBoost transformation unless \code{squeeze = FALSE}. Optional when interval bounds are supplied.}

\item{selector}{Selection routine. Defaults to \code{\link[=betareg_step_aic]{betareg_step_aic()}}.
Function or character string. If it is a function, the selector name
should be added as the fun.name attribute.}

\item{corrfunc}{Correlation function passed to \code{\link[=sb_compute_corr]{sb_compute_corr()}}.}

\item{B}{Number of replicates to generate.}

\item{step.num}{Step length for the automatically generated \code{c0} grid.}

\item{steps.seq}{Optional user-supplied grid of absolute correlation
thresholds.}

\item{version}{Either \code{"glmnet"} (intercept in first row) or \code{"lars"}.}

\item{squeeze}{Logical; ensure the response lies in \verb{(0, 1)}.}

\item{use.parallel}{Logical; enable parallel resampling and selector fits
when supported by the current R session.}

\item{seed}{Optional integer seed for reproducibility. The seed is scoped via
\code{\link[withr:with_seed]{withr::with_seed()}} so the caller's RNG state is restored on exit.}

\item{verbose}{Logical; emit progress messages.}

\item{threshold}{Numeric tolerance for considering a coefficient selected.}

\item{interval}{Interval-resampling mode: \code{"none"} reuses \code{Y}, whereas
\code{"uniform"} and \code{"midpoint"} draw pseudo-responses between \code{Y_low} and
\code{Y_high} for each replicate.}

\item{Y_low, Y_high}{Interval bounds in \verb{[0, 1]} paired with the rows of \code{X}
when \code{interval} is not \code{"none"}.}

\item{...}{Additional arguments forwarded to \code{selector}.}
}
\value{
Matrix of selection frequencies with one row per \code{c0} level and class
\code{"sb_beta"}. See \emph{Details} for the recorded attributes.
}
\description{
\code{sb_beta()} orchestrates all SelectBoost stages—normalisation, correlation
analysis, grouping, correlated resampling, and stability tallying—while using
the beta-regression selectors provided by this package. It can operate on
point-valued or interval-valued responses and automatically squeezes the
outcome into \verb{(0, 1)} unless instructed otherwise.
}
\details{
The returned object carries a rich set of attributes:
\itemize{
\item \code{"c0.seq"} – the grid of absolute-correlation thresholds explored during
resampling.
\item \code{"steps.seq"} – the raw sequence (if any) used to construct the grid.
\item \code{"selector"} – the selector identifier (function name or expression).
\item \code{"B"} – number of resampled designs passed to the selector.
\item \code{"interval"} – the interval sampling mode (\code{"none"}, \code{"uniform"}, or
\code{"midpoint"}).
\item \code{"resample_diagnostics"} – per-threshold data frames with summary
statistics on the cached correlated draws.
}

These attributes mirror the historical SelectBoost beta implementation so the
object can be consumed by existing plotting and reporting utilities.
}
\examples{
set.seed(42)
sim <- simulation_DATA.beta(n = 80, p = 4, s = 2)
# increase B for real applications
res <- sb_beta(sim$X, sim$Y, B = 5)
res
}
