% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DummyApply.R
\name{DummyApply}
\alias{DummyApply}
\title{Apply a function to subsets defined by a dummy matrix}
\usage{
DummyApply(x, y, FUN = sum, simplify = TRUE)
}
\arguments{
\item{x}{A (sparse) dummy matrix}

\item{y}{Vector of input values}

\item{FUN}{A function}

\item{simplify}{Parameter to \code{\link{aggregate}}. When \code{FALSE}, list output is ensured.}
}
\value{
Vector of output values or a matrix when multiple outputs from \code{FUN}  (see examples).
List output is also possible (ensured when \code{simplify = FALSE}).
}
\description{
For each column, \code{i},  of the matrix \code{x} of zeros and ones, the output value is equivalent to \code{FUN(y[x[, i] != 0])}.
}
\details{
With a dummy \code{x} and \code{FUN = sum}, output is equivalent to \code{z = t(x) \%*\% y}.
}
\examples{

z <- SSBtoolsData("sprt_emp_withEU")
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

a <- ModelMatrix(z, formula = ~age + geo, crossTable = TRUE)

cbind(as.data.frame(a$crossTable), 
      sum1 = (Matrix::t(a$modelMatrix) \%*\% z$ths_per)[,1],
      sum2 = DummyApply(a$modelMatrix, z$ths_per, sum),
       max = DummyApply(a$modelMatrix, z$ths_per, max))
       
DummyApply(a$modelMatrix, z$ths_per, range)
DummyApply(a$modelMatrix, z$ths_per, range, simplify = FALSE)  

a$modelMatrix[, c(3, 5)] <- 0   # Introduce two empty columns. 
DummyApply(a$modelMatrix, z$ths_per, function(x){ 
  c(min = min(x), 
    max = max(x), 
    mean = mean(x), 
    median = median(x), 
    n = length(x))})   
    
DummyApply(a$modelMatrix, z$ths_per, function(x) x, simplify = FALSE)          

}
