% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semPaths.R
\name{SEMpath}
\alias{SEMpath}
\title{Search for directed or shortest paths between pairs of source-sink nodes}
\usage{
SEMpath(graph, data, group, from, to, path, verbose = FALSE, ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{data}{A matrix or data.frame. Rows correspond to subjects, and
columns to graph nodes (variables).}

\item{group}{A binary vector. This vector must be as long as the
number of subjects. Each vector element must be 1 for cases and 0
for control subjects. If \code{NULL} (default), group influence will
not be considered.}

\item{from}{Starting node name (i.e., source node).}

\item{to}{Ending node name (i.e., sink node).}

\item{path}{If \code{path = "directed"}, all directed paths between
the two nodes will be included in the fitted model.
If \code{path = "shortest"}, only shortest paths will be returned.}

\item{verbose}{Show the directed (or shortest) path between the
given source-sink pair inside the input graph.}

\item{...}{Currently ignored.}
}
\value{
A list of four objects: a fitted model object of class
\code{\link[lavaan]{lavaan}} ("fit"), aggregated and node-specific
group effect estimates and P-values ("gest"), the extracted subnetwork
as an igraph object ("graph"), and the input graph with a color
attribute mapping the chosen path ("map").
}
\description{
Find and fit all directed or shortest paths between two
source-sink nodes of a graph.
}
\examples{

# Directed path fitting
path <- SEMpath(graph = sachs$graph, data = log(sachs$pkc),
                group = sachs$group,
                from = "PIP3",
                to = "Erk",
                path = "directed")

# Summaries
summary(path$fit)
print(path$gest)

# Graphs
gplot(path$map, main="path from PiP2 to Erk")
plot(path$map, layout=layout.circle, main="path from PiP2 to Erk")

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
