% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_env.R
\name{thin_env}
\alias{thin_env}
\title{Flag records that are close to each other in the enviromnetal space}
\usage{
thin_env(
  occ,
  species = "species",
  long = "decimalLongitude",
  lat = "decimalLatitude",
  env_layers,
  n_bins = 5,
  prioritary_column = NULL,
  decreasing = TRUE,
  flag_for_NA = FALSE
)
}
\arguments{
\item{occ}{(data.frame or data.table) a data frame containing the occurrence
records. Must contain columns for species, longitude, and latitude.}

\item{species}{(character) the name of the column in \code{occ} that contains the
species scientific names. Default is \code{"species"}.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{env_layers}{(SpatRaster) object containing environmental variables.}

\item{n_bins}{(numeric) number of bins into which each environmental variable
will be divided.}

\item{prioritary_column}{(character) name of a numeric columns in \code{occ}to
define retention priority (e.g., quality score, year). See details.}

\item{decreasing}{(logical) whether to sort records in decreasing order using
the \code{prioritary_column} (e.g., from most recent to oldest when the variable
is \code{"year"}). Only applicable when \code{prioritary_column} is not \code{NULL}.
Default is \code{TRUE}.}

\item{flag_for_NA}{(logical) whether to treat records falling in \code{NA} cells
of \code{env_layers} as valid (\code{TRUE}) or invalid (\code{FALSE}). Default is \code{FALSE}.}
}
\value{
The original \code{occ} data frame with two additional columns:
\itemize{
\item \code{thin_env_flag}: logical indicating whether each record is retained
(\code{TRUE}) or flagged as redundant (\code{FALSE}).
\item \code{bin}: environmental bin ID assigned to each record. Each component
of the ID corresponds to the bin of one environmental variable.
}
}
\description{
Flags occurrence records for thinning by keeping only one record per species
within the same environmental block/bin.
}
\details{
This function used \code{get_env_bins()} to create a multidimensional grid in
environmental space by splitting each environmental variable into \code{n_bins}
equally sized intervals. Records falling into the same environmental bin are
considered redundant; only one is kept (based on retention priority when
provided), and the remaining records are flagged.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Get only occurrences from Araucaria
occ <- occurrences[occurrences$species == "Araucaria angustifolia", ]
# Load example of raster variables
data("worldclim", package = "RuHere")
# Unwrap Packed raster
r <- terra::unwrap(worldclim)
# Flag records that are close to each other in the enviromnetal space
occ_env_thin <- thin_env(occ = occ, env_layers = r)
# Number of flagged (redundant) records
sum(!occ_env_thin$thin_env_flag) #Number of flagged records
}
