% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_here.R
\name{map_here}
\alias{map_here}
\title{Interactive Visualization of Occurrence Flags with mapview}
\usage{
map_here(
  occ,
  species = NULL,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  flags = "all",
  additional_flags = NULL,
  names_additional_flags = NULL,
  col_additional_flags = NULL,
  show_no_flagged = TRUE,
  cex = 6,
  lwd = 2,
  col_points = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{occ}{(data.frame or data.table) a dataset containing occurrence records
that has been processed by one or more flagging functions. See \emph{Details} for
available flag types.}

\item{species}{(character) name of the species to subset and plot. Default is
\code{NULL}, meaning that all records for all species are plotted.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{flags}{(character) the flags to be used for coloring the records. Use
\code{"all"} to display all available flags. See \emph{Details} for all options.
Default is \code{"all"}.}

\item{additional_flags}{(character) an optional named character vector with
the names of additional logical columns to be used as flags. Default is \code{NULL}.}

\item{names_additional_flags}{(character) an optional different name to the
flag provided in \code{additional_flags} to be shown in the map. Only applicable
if \code{additional_flags} is not NULL.}

\item{col_additional_flags}{(character) if \code{additional_flags} is provided,
the color of the records flagged in this column. Obligatory if
\code{additional_flags} is not NULL.}

\item{show_no_flagged}{(logical) whether to display records that did not
receive any flag.Default is TRUE.}

\item{cex}{(numeric) point size for plotting occurrences. Default is 6.}

\item{lwd}{(numeric) line width for point borders. Default is 2.}

\item{col_points}{(character) A \strong{named vector} assigning colors to each
flag. If \code{NULL}, default colors from the internal object
\code{RuHere::flag_colors()} are used.}

\item{label}{(character) column name in \code{occ} to use as the mouseover label.
Default is \code{NULL}, in which case the record's row number is displayed.}

\item{...}{additional arguments passed to \code{mapview::mapview()}.}
}
\value{
An interactive mapview object displaying flagged and optionally unflagged
occurrence records.
}
\description{
This function creates an interactive map of occurrence records using
\strong{mapview}, visually highlighting flags. This tool helps users explore which
records were flagged by one or more validation functions and inspect them
directly on the map.
}
\details{
The following flags are available: correct_country, correct_state, cultivated,
fossil, inaturalist, faunabr, florabr, wcvp, iucn, duplicated, thin_geo,
thin_env, .val, .equ, .zer, .cap, .cen, .sea, .urb, .otl, .gbf, .inst, and
.aohi.

These flags are typically generated by functions in the \code{RuHere} or
\code{CoordinateCleaner}workflow to identify potential data-quality issues in
occurrence records.

Users may also supply additional logical columns using
\code{additional_flags}, optionally providing alternative display names
(\code{names_additional_flags}) and colors (\code{col_additional_flags}).
}
\examples{
\donttest{
# Load example data
data("occ_flagged", package = "RuHere")
# Visualize flags interactively
map_here(occ = occ_flagged, label = "record_id")
}
}
