% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_here.R
\name{bind_here}
\alias{bind_here}
\title{Bind occurrences after standardizing columns}
\usage{
bind_here(..., fill = FALSE)
}
\arguments{
\item{...}{(data.frame) two or more data frames with occurrence records to
combine.}

\item{fill}{(logical) whether to fills missing columns with \code{NA}. Default is
FALSE.}
}
\value{
A \code{data.frame} containing all occurrence records combined.
}
\description{
Combines multiple occurrence data frames (for example, from GBIF,
SpeciesLink, BIEN, or iDigBio) into a single standardized dataset. This is
particularly useful after using \code{format_columns()} to ensure column
compatibility across data sources.
}
\details{
When \code{fill = TRUE}, columns not shared among the input data frames are added
and filled with \code{NA}, ensuring that all columns align before binding.
Internally, this function uses \code{data.table::rbindlist()} for efficient row
binding.
}
\examples{
# Import and standardize GBIF
data("occ_gbif", package = "RuHere") #Import data example
gbif_standardized <- format_columns(occ_gbif, metadata = "gbif")
# Import and standardize SpeciesLink
data("occ_splink", package = "RuHere") #Import data example
splink_standardized <- format_columns(occ_splink, metadata = "specieslink")
# Import and standardize BIEN
data("occ_bien", package = "RuHere") #Import data example
bien_standardized <- format_columns(occ_bien, metadata = "bien")
# Import and standardize idigbio
data("occ_idig", package = "RuHere") #Import data example
idig_standardized <- format_columns(occ_idig, metadata = "idigbio")
# Merge all
all_occ <- bind_here(gbif_standardized, splink_standardized,
                      bien_standardized, idig_standardized)

}
