% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAvgOverlap.R
\name{findAvgOverlap}
\alias{findAvgOverlap}
\title{Find average image overlaps}
\usage{
findAvgOverlap(
  list_img_paths = NULL,
  list_imgs = NULL,
  overlap_px = NULL,
  max_shift_px = NULL,
  perc_better_per_px = 0.01,
  corr_formula = "1-rel_eucl_diff_colors",
  stitch_direction = "left_to_right"
)
}
\arguments{
\item{list_img_paths}{(Optional, default = NULL) List containing several
character vector specifying all of the individual image paths of interest.
Each vector must contain the same number of image paths with the
images all having the same dimensions.
This is only used if \code{list_imgs} is set to NULL.}

\item{list_imgs}{List of lists of images (e.g., provided by the
RootDetector). Each sublist must contain the same number of images with the
same dimensions.
Each image can be a PNG, i.e., an array with 3 dimensions (3 layers each
containing a 2-dim. numeric matrix with values between 0 and 1), or a 2-dim.
matrix.}

\item{overlap_px}{Numeric vector (default NULL) specifying the (likely)
widths of the overlaps between two consecutive images. The vector must have
one element less than there are images and must not contain any negative
values. If NULL, it is set to 1's.}

\item{max_shift_px}{Numeric vector (default NULL) specifying the maximal
deviation in pixels from the \code{overlap_px}, i.e., all possible
overlaps in that range from the likely overlap are compared and the best
is chosen if it is better than the \code{overlap_px} (see also
\code{perc_better_per_px}). If \code{overlap_px} is already exact, then set
\code{max_shift_px} to zero(s). If at NULL, it is set to 10 percent of the
image widths.}

\item{perc_better_per_px}{Numeric value (percentage, default 0.01, i.e., 1
percent) specifying how much better the correlation of an overlap must be
than the \code{overlap_px} per pixel difference, to be selected instead.
See \code{findOverlap()} for more details. The corresponding threshold
correlation values are only reported, but do not affect the computation
of the average/best overlaps.}

\item{corr_formula}{Character value specifying the formula to be used
(by default 1) for calculating how good an overlap of two images is, i.e.,
how similar the two overlapping images are. Available are the following
formulas: \cr
\itemize{
\item "frac_matches_rgb_intensities": Fraction of matching intensities over all
three color channels. Only suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "frac_matches_colors": Fraction of matching colors in the images. Only
suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "weighted_matches_b_w": Counts the matches of black and white pixels and
weighs them anti-proportional to the black and white pixel frequencies.
Both black and white make up half of the correlation score.
Only suitable for images with mostly pure black and white pixels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "weighted_matches_colors": Counts the matches per unique color and weighs
them anti-proportional to the frequencies of the colors.
Each unique color makes up the same fraction of the correlation score.
Only suitable for images with few unique colors.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_sqrd_diff_rgb_intensities": One minus the relative squared
difference of intensities across all color channels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_abs_diff_rgb_intensities": One minus the relative absolute
difference of intensities across all color channels.
Ranges from 0 (no matches) to 1 (full match).\cr
\item "1-rel_eucl_diff_colors" (default): One minus the relative Euclidean
differences of colors.
Ranges from 0 (no matches) to 1 (full match).
}}

\item{stitch_direction}{Character specifying in which order the images
should be stitched. Available are: 'left_to_right' (default),
'right_to_left', 'top_to_bottom', and 'bottom_to_top'.}
}
\value{
\code{findAvgOverlap} List containing the best overlaps, i.e., a
numeric vector containing the best (according to the parameters) widths of
the overlaps between the consecutive images (this vector has one element
less than there are images) as well as a list containing all possible
overlap information per image set.
}
\description{
\code{findAvgOverlap} - This function looks at several sets of images, which
overlap in the same way, for example the root scans (with more than one
depth window) of the same minirhizotron. It then computes the best overlap
between each pair of consecutive images (see parameters for more details on
the method) for each set of images. The best results are then found for each
image transition across all image sets depending based on the correlation
values.
}
\examples{
# Example of finding the best overlap of two sets of two matrices.
overlap <- findAvgOverlap(list_imgs = list(
                              list(matrix(c(1,0,0,0,
                                            0,1,0,0,
                                            0,0,1,1), ncol = 4, nrow = 3,
                                      byrow = TRUE),
                                   matrix(c(0,0,0,0,
                                            1,0,0,1,
                                            0,1,1,0), ncol = 4, nrow = 3,
                                      byrow = TRUE)),
                              list(matrix(c(0,0,0,0,
                                            0,0,0,0,
                                            0,0,1,1), ncol = 4, nrow = 3,
                                      byrow = TRUE),
                                   matrix(c(0,0,0,0,
                                            0,0,0,0,
                                            1,1,1,0), ncol = 4, nrow = 3,
                                      byrow = TRUE))),
                       overlap_px = 1, max_shift_px = 2,
                       corr_formula = "weighted_matches_b_w")
overlap$best_overlaps
}
