% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quebec.R
\name{quebec}
\alias{quebec}
\title{quebec}
\usage{
quebec(site, variable, start_date = NULL, end_date = NULL, sites = FALSE, ...)
}
\arguments{
\item{site}{quebec gauge number}

\item{variable}{Character. Either \code{stage} or \code{discharge}.}

\item{start_date}{Character. Optional start date with format
YYYY-MM-DD. Default is 1900-01-01.}

\item{end_date}{Character. End date with format YYYY-MM-DD.
Default is the current date.}

\item{sites}{Logical. If TRUE, returns a list of measurement
sites.}

\item{...}{Additional arguments. None implemented.}
}
\value{
data frame of discharge time-series
}
\description{
Retrieve Quebec gauge data
}
\examples{
\donttest{
site <- "074903"
x <- quebec(site, variable = "stage")
plot(x$Date, x$H, type='l')
}
}
