% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_frequentist.R
\name{binary_segmentation}
\alias{binary_segmentation}
\title{Binary Segmentation Changepoint Detection}
\usage{
binary_segmentation(
  data,
  type = "both",
  penalty = "BIC",
  min_segment = 2,
  n_changepoints = "multiple",
  threshold = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix}

\item{type}{Type of change to detect}

\item{penalty}{Penalty for adding changepoints}

\item{min_segment}{Minimum segment length}

\item{n_changepoints}{Maximum number of changepoints to detect}

\item{threshold}{Significance threshold}

\item{...}{Additional arguments}
}
\value{
List with changepoints
}
\description{
Recursive binary segmentation for changepoint detection.
Greedy algorithm that recursively splits at the best changepoint.
}
\examples{
data <- c(rnorm(100), rnorm(100, mean = 2))
result <- binary_segmentation(data)

}
