% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{detect_complex_types}
\alias{detect_complex_types}
\title{Detect Complex Types in DuckDB Table}
\usage{
detect_complex_types(con, table_name)
}
\arguments{
\item{con}{A DuckDB connection}

\item{table_name}{Name of the table to analyze}
}
\value{
A data frame with columns that have complex types, showing
  column_name, column_type, and a description of R type.
}
\description{
Identifies columns in a DuckDB table that contain complex types
(ARRAY or MAP) that will be returned as R lists.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
bcf_path <- system.file("extdata", "vcf_file.bcf", package = "Rduckhts")
rduckhts_bcf(con, "variants", bcf_path, overwrite = TRUE)
complex_cols <- detect_complex_types(con, "variants")
print(complex_cols)
dbDisconnect(con, shutdown = TRUE)

}
