% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppTskit.R
\name{ts_load}
\alias{ts_load}
\alias{ts_read}
\title{Load a tree sequence from a file}
\usage{
ts_load(file, skip_tables = FALSE, skip_reference_sequence = FALSE)

ts_read(file, skip_tables = FALSE, skip_reference_sequence = FALSE)
}
\arguments{
\item{file}{a string specifying the full path to a tree sequence file.}

\item{skip_tables}{logical; if \code{TRUE}, load only non-table information.}

\item{skip_reference_sequence}{logical; if \code{TRUE}, skip loading
reference sequence information.}
}
\value{
A \code{\link{TreeSequence}} object.
}
\description{
Load a tree sequence from a file
}
\details{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.load}.
}
\section{Functions}{
\itemize{
\item \code{ts_read()}: Alias for \code{ts_load()}

}}
\examples{
ts_file <- system.file("examples/test.trees", package = "RcppTskit")
ts <- ts_load(ts_file)
is(ts)
ts
ts$num_nodes()
# Also
ts <- TreeSequence$new(file = ts_file)
is(ts)
}
\seealso{
\code{\link[=TreeSequence]{TreeSequence$new}}
}
