% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{compumap}
\alias{compumap}
\title{Computation of a two dimensional umap representation}
\usage{
compumap(
  object,
  dimRed = FALSE,
  n_neighbors = 15,
  metric = "euclidean",
  n_epochs = 200,
  min_dist = 0.1,
  local_connectivity = 1,
  spread = 1
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{dimRed}{logical. If \code{TRUE} then the umap is computed from the feature matrix in slot \code{dimRed$x} (if not equal to \code{NULL}).
Default is \code{FALSE} and the umap is computed from the distance matrix stored in slot \code{distances}. If slot \code{distances} equals \code{NULL}
\code{dimRed} is automatially set to \code{TRUE}.}

\item{n_neighbors}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 15.}

\item{metric}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is "euclidean".}

\item{n_epochs}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 200.}

\item{min_dist}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 0.1.}

\item{local_connectivity}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 1.}

\item{spread}{Umap parameter. See \code{help(umap.defaults)} after loading package \pkg{umap}. Default is 1.}
}
\value{
\code{SCseq} object with umap coordinates stored in slot \code{umap}.
}
\description{
This functions performs the computation of a two-dimensional umap representation based on the distance matrix in
slot \code{distances} using the \pkg{umap} package.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
sc <- compumap(sc)
}
