% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_add_neighbors.R
\name{add_neighbors}
\alias{add_neighbors}
\title{Add neighbors to adjacency information}
\usage{
add_neighbors(adjacency, neighs)
}
\arguments{
\item{adjacency}{Adjacency information generated by \code{spdep::poly2nb()}.}

\item{neighs}{A vector of regions to mark as adjacent. Accepts a vector of indices or names assigned to \code{adjacency}.}
}
\value{
A modified \code{adjacency} \code{list}.
}
\description{
Modifies \code{adjacency} to indicate that \code{neighs} they should be treated as neighbors.
}
\details{
\code{add_neighbors()} is useful when adjacency information generated by \code{spdep::poly2nb()} indicates lone regions without links/neighbors, particularly in island counties such as the Hawaiian islands, Nantucket in Massachusetts, or San Juan in Washington. Note that \code{add_neighbors()} marks all listed counties as adjacent, so if you have a set of chaining counties where the first may not be connected to the last, several instances of \code{add_neighbors()} will be needed.
}
\examples{
if (requireNamespace("sf", quietly = TRUE) &&
    requireNamespace("spdep", quietly = TRUE)) {

  mamap <- sf::st_as_sf(mamap[order(mamap$GEOID), ])
  ma_adj <- spdep::poly2nb(mamap)
  new_neighs <- c(1, 4, 10) # attach regions 1, 4, and 10
  ma_adj <- add_neighbors(ma_adj, new_neighs)

  # Add neighbors by FIPS code instead of index
  ma_adj <- suppressWarnings(spdep::poly2nb(mamap))
  names(ma_adj) <- mamap$GEOID
  ma_adj <- add_neighbors(ma_adj, neighs = c("25001", "25007", "25019"))

  ma_adj <- suppressWarnings(spdep::poly2nb(mamap))
  ma_adj <- add_neighbors(ma_adj, c(1, 4)) # only attach 1 and 4
  ma_adj <- add_neighbors(ma_adj, c(4, 10)) # only attach 4 and 10
}
}
