% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_and_downsample.R
\name{calculate_missing_data}
\alias{calculate_missing_data}
\title{Calculate the missing data amount}
\usage{
calculate_missing_data(data, pupil)
}
\arguments{
\item{data}{your data of class PupillometryR}

\item{pupil}{a column name denoting pupil size}
}
\value{
A summary table with number of missing samples in each trial
}
\description{
This function can be used to assess the amount of samples that have problematic
data from each trial, which helps assess cleaning parameters
}
\examples{
data(pupil_data)
Sdata <- make_pupillometryr_data(data = pupil_data,
subject = ID,
trial = Trial,
time = Time,
condition = Type)
new_data <- downsample_time_data(data = Sdata,
pupil = LPupil,
timebin_size = 50,
option = 'mean')
calculate_missing_data(data = new_data, pupil = LPupil)
}
