% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm-no_bias.R
\name{dgm.no_bias}
\alias{dgm.no_bias}
\title{Normal Unbiased Data-Generating Mechanism}
\usage{
\method{dgm}{no_bias}(dgm_name, settings)
}
\arguments{
\item{dgm_name}{DGM name (automatically passed)}

\item{settings}{List containing \describe{
\item{mean_effect}{Mean effect}
\item{heterogeneity}{Effect heterogeneity}
\item{n_studies}{Number of effect size estimates}
}}
}
\value{
Data frame with \describe{
\item{yi}{effect size}
\item{sei}{standard error}
\item{ni}{sample size}
\item{es_type}{effect size type}
}
}
\description{
An example data-generating mechanism to simulate effect sizes without
publication bias.
}
\details{
Sample sizes of individual effect size estimates are generated from a
negative binomial distribution based on empirical sample size distribution
presented in Appendix B of
\insertCite{maier2023robust;textual}{PublicationBiasBenchmark}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=dgm]{dgm()}}, \code{\link[=validate_dgm_setting]{validate_dgm_setting()}}
}
