% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm-Alinaghi2018.R
\name{dgm.Alinaghi2018}
\alias{dgm.Alinaghi2018}
\title{Alinaghi and Reed (2018) Data-Generating Mechanism}
\usage{
\method{dgm}{Alinaghi2018}(dgm_name, settings)
}
\arguments{
\item{dgm_name}{DGM name (automatically passed)}

\item{settings}{List containing \describe{
\item{environment}{Type of the simulation environment. One of \code{"FE"},
\code{"RE"}, or \code{"PRE"}.}
\item{mean_effect}{Mean effect}
\item{bias}{Type of publication bias. One of \code{"none"}, \code{"positive"},
or \code{"significant"}.}
}}
}
\value{
Data frame with \describe{
\item{yi}{effect size}
\item{sei}{standard error}
\item{ni}{sample size}
\item{study_id}{study identifier}
\item{es_type}{effect size type}
}
}
\description{
This data-generating mechanism simulates univariate regression studies where a variable X
affects a continuous outcome Y. Each study estimates the coefficient of X, which consists
of a fixed component (alpha1) representing the overall mean effect, and a random component
that varies across studies but is constant within each study. In the "Random Effects"
environment (\code{"RE"}), each study produces one estimate, and the population effect
differs across studies. In the "Panel Random Effects" environment (\code{"PRE"}), each
study has 10 estimates, modeling the common scenario where multiple estimates per study
are available, with publication selection targeting the study rather than individual estimates.

The description and code is based on
\insertCite{hong2021using;textual}{PublicationBiasBenchmark}.
The data-generating mechanism was introduced in
\insertCite{alinaghi2018meta;textual}{PublicationBiasBenchmark}.
}
\details{
This data-generating mechanism is based on Alinaghi & Reed (2018), who study univariate
regression models where a variable X affects a continuous variable Y. The parameter
of interest is the coefficient on X. In the "Random Effects" environment (\code{"RE"}),
each study produces one estimate, and the population effect differs across studies.
The coefficient on X equals a fixed component (alpha1) plus a random component that is
fixed within a study but varies across studies. The overall mean effect of X on Y is
given by alpha1. In the "Panel Random Effects" environment (\code{"PRE"}), each study has
10 estimates, modeling the common scenario where multiple estimates per study are
available. In this environment, effect estimates and standard errors are simulated to
be more similar within studies than across studies, and publication selection targets
the study rather than individual estimates (a study must have at least 7 out of 10
estimates that are significant or correctly signed.).

A distinctive feature of Alinaghi & Reed's experiments is that the number of
effect size estimates  is fixed before publication selection, making the meta-analyst's
sample size endogenous and affected by the effect size. Large population effects
are subject to less publication selection, as most estimates satisfy the selection
criteria (statistical significance or correct sign). The sample size of all primary
studies is fixed at 100 observations. (Neither the number of estimates nor the sample
size of primary studies can be changed in the current implementation of the function.)

Another feature is the separation of statistical significance and sign of the estimated
effect as criteria for selection. Significant/correctly-signed estimates are always
"published," while insignificant/wrong-signed estimates have only a 10\% chance of
being published. This allows for different and sometimes conflicting consequences for
estimator performance.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=dgm]{dgm()}}, \code{\link[=validate_dgm_setting]{validate_dgm_setting()}}
}
