% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walk_forward.R
\name{plot.wf_optimization_result}
\alias{plot.wf_optimization_result}
\title{Plot Walk-Forward Results}
\usage{
\method{plot}{wf_optimization_result}(
  x,
  y = NULL,
  type = c("parameters", "is_oos", "equity", "drawdown", "windows", "stability",
    "distributions"),
  param = NULL,
  metric = NULL,
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{wf_optimization_result} from \code{\link[=run_walk_forward]{run_walk_forward()}}.}

\item{y}{Ignored.}

\item{type}{One of "parameters","is_oos","equity","drawdown",
"windows","stability","distributions".}

\item{param}{Character vector of parameter names to include for
"parameters"/"stability"/"distributions". If \code{NULL}, uses all.}

\item{metric}{Character; column to plot for "is_oos" or "windows"
(e.g., "OOS_Return" or "OOS_Score"). Ignored for other types.}

\item{main, sub, xlab, ylab}{Base plotting annotations.}

\item{...}{Additional plot options (type-specific).}
}
\value{
Invisibly, a small list describing the plot.
}
\description{
Visual diagnostics for a \code{wf_optimization_result} returned by
\code{\link[=run_walk_forward]{run_walk_forward()}}. Supported types:
\itemize{
\item "parameters": best parameter values chosen per window.
\item "is_oos": in-sample vs out-of-sample scores by window.
\item "equity": stitched out-of-sample equity curve.
\item "drawdown": drawdown of the stitched OOS curve.
\item "windows": per-window bar/line chart of an OOS metric (see \code{metric}).
\item "stability": summary of parameter stability.
\item "distributions": distributions of IS/OOS scores across windows.
}
}
\examples{
\donttest{
  data(sample_prices_weekly)
  b <- function(prices, params, ...) {
    weight_equally(filter_top_n(calc_momentum(prices, params$lookback),
                                params$top_n))
  }
  wf <- run_walk_forward(
    prices = sample_prices_weekly,
    grid   = list(lookback = c(8, 12, 26), top_n = c(5, 10)),
    builder = b,
    is_periods = 52, oos_periods = 26, step = 26
  )
  plot(wf, type = "parameters")
  plot(wf, type = "is_oos", metric = "OOS_Score")
}

}
\seealso{
\code{\link[=run_walk_forward]{run_walk_forward()}}, \code{\link[=wf_report]{wf_report()}}, \code{\link[=print.wf_optimization_result]{print.wf_optimization_result()}}
}
