% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_indices.R
\name{all_indices}
\alias{all_indices}
\title{Computation of All Stress Indices at Once}
\usage{
all_indices(
  Gen,
  YN,
  YS,
  YMN = NULL,
  YMS = NULL,
  include_inputs = TRUE,
  name_vectors_by_gen = TRUE
)
}
\arguments{
\item{Gen}{Character vector of Genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMN, YMS}{Optional numeric scalars for environment means. If NULL, computed.}

\item{include_inputs}{Logical; if TRUE returns a list with \code{YMN}, \code{YMS}, and \code{all}.}

\item{name_vectors_by_gen}{Ignored; kept for backward compatibility.}
}
\value{
If \code{include_inputs=TRUE}, a list with \code{YMN}, \code{YMS}, and \code{all} data frame.
}
\description{
A convenience function that returns a data frame with 11 stress indices—Stress Tolerance (TOL), Stress Tolerance Index (STI), Stress Susceptibility Percentage Index (SSPI), Yield Index (YI), Yield Stability Index (YSI), Relative Stress Index (RSI), Mean Productivity (MP), Geometric Mean Productivity (GMP), Harmonic Mean (HM), Mean Relative Performance (MRP), and Percent Yield Reduction (PYR)—for the same given inputs (Lamba et al., 2023; \url{doi:10.1038/s41598-023-37634-8}).
}
\examples{
out <- all_indices(
Gen=c("G1","G2","G3"),
YN=c(10,8,5), YS=c(7,5,3)
)
print(out)
}
\references{
Lamba, K., Kumar, M., Singh, V. et al. (2023). \url{doi:10.1038/s41598-023-37634-8}.
}
