% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addAge}
\alias{addAge}
\title{Compute the age of the individuals at a certain date}
\usage{
addAge(
  x,
  indexDate = "cohort_start_date",
  ageName = "age",
  ageGroup = NULL,
  ageMissingMonth = 1,
  ageMissingDay = 1,
  ageImposeMonth = FALSE,
  ageImposeDay = FALSE,
  ageUnit = "years",
  missingAgeGroupValue = "None",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the
demographics characteristics.}

\item{ageName}{Age variable name.}

\item{ageGroup}{if not NULL, a list of ageGroup vectors.}

\item{ageMissingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{ageMissingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{ageImposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{ageImposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{ageUnit}{Unit for age it can either be 'years', 'months' or 'days'.}

\item{missingAgeGroupValue}{Value to include if missing age.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
tibble with the age column added.
}
\description{
Compute the age of the individuals at a certain date
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addAge()

}
}
