% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_MQ.R
\name{getFragmentErrors}
\alias{getFragmentErrors}
\title{Extract fragment mass deviation errors from a data.frame from msms.txt}
\usage{
getFragmentErrors(x, recurse = 0)
}
\arguments{
\item{x}{Data frame in long format with numerical expression data}

\item{recurse}{Internal usage only. Leave at 0 when calling.}
}
\value{
Data frame with mass errors ('msErr') and their 'unit' (Da or ppm) or NULL (if no fragments were given)
}
\description{
Given a data.frame as obtainable from a msms.txt with
 - a 'mass.analyzer' column which contains only a single value for the whole column
 - a 'mass.deviations..da.' and (if available) 'mass.deviations..ppm.'
 - a 'masses' column (only required if 'mass.deviations..ppm.' is unavailable and the mass.analyzer
   indicates hig-res data)
}
\details{
Mass deviations are extracted from the columns, e.g. each cell containing values separated by
semicolons is split into single values. The appropriate unit is chosen (Da or ppm, depending on
ITMS or FTMS data). Also the fragmentation type can be used: CID indicates ITMS, HCD to FTMS.
This is not 100% safe, but older MQ versions do not report the mass analyzer properly.

Sometimes, peptides are identified purely based on MS1, i.e. have no fragments. These will be ignored.

If ppm mass deviations are not available, errors in Da will be converted to ppm using the corresponding mass values.
}
