% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helping_functions.R
\name{summarize_ptsd_changes}
\alias{summarize_ptsd_changes}
\title{Summarize changes in PTSD diagnostic metrics}
\usage{
summarize_ptsd_changes(data)
}
\arguments{
\item{data}{A dataframe where:

\itemize{
  \item  Each column represents a different diagnostic criterion
  \item  Must include a column named "PTSD_orig" as the baseline criterion
  \item  Values are logical (TRUE/FALSE) indicating whether PTSD criteria are met
  \item  Each row represents one case/participant
}}
}
\value{
A dataframe containing the following columns for each diagnostic criterion:

\itemize{
  \item  column: Name of the diagnostic criterion
  \item  diagnosed: Number of cases diagnosed as PTSD
  \item  non_diagnosed: Number of cases not diagnosed as PTSD
  \item  diagnosed_percent: Percentage of cases diagnosed
  \item  non_diagnosed_percent: Percentage of cases not diagnosed
  \item  newly_diagnosed: Cases diagnosed under new but not baseline criterion
    (false positive)
  \item  newly_nondiagnosed: Cases diagnosed under baseline but not new criterion
    (false negative)
  \item  true_positive: Cases diagnosed under both criteria
  \item  true_negative: Cases not diagnosed under either criterion
  \item  true_cases: Sum of true positives and true negatives
  \item  false_cases: Sum of newly diagnosed (false positive) and newly non-diagnosed
    (false negative)
  \item  sensitivity, specificity, ppv, npv: Standard diagnostic accuracy metrics
}
}
\description{
Compares different PTSD diagnostic criteria by calculating diagnostic accuracy
metrics and changes in diagnosis status relative to a baseline criterion.
}
\details{
The function calculates multiple diagnostic metrics comparing each diagnostic
criterion to a baseline criterion (PTSD_orig):

Basic counts:

\itemize{
\item  Number and percentage of diagnosed/non-diagnosed cases per criterion
\item  Number of newly diagnosed (false positive) and newly non-diagnosed
  (false negative) cases
\item  True positive and true negative cases
}

Diagnostic accuracy metrics:

\itemize{
\item  Sensitivity: Proportion of true PTSD cases correctly identified
\item  Specificity: Proportion of non-PTSD cases correctly identified
\item  PPV (Positive Predictive Value): Probability that a positive diagnosis is correct
\item  NPV (Negative Predictive Value): Probability that a negative diagnosis is correct
}
}
\examples{
# Create sample diagnostic data
set.seed(123)
n_cases <- 100
sample_data <- data.frame(
  PTSD_orig = sample(c(TRUE, FALSE), n_cases, replace = TRUE),
  PTSD_alt1 = sample(c(TRUE, FALSE), n_cases, replace = TRUE),
  PTSD_alt2 = sample(c(TRUE, FALSE), n_cases, replace = TRUE)
)

# Calculate diagnostic metrics
diagnostic_metrics <- summarize_ptsd_changes(sample_data)
diagnostic_metrics

}
