test_that("compute_msg works correctly", {
  expect_equal(compute_msg(c(5, 15, 20), 25), 0.8)
  expect_equal(compute_msg(c(0, 0, 0), 25), 0)
  expect_equal(compute_msg(c(25), 25), 1.0)
  expect_error(compute_msg(c(-1, 5), 25))
  expect_error(compute_msg(c(30), 25))
  expect_error(compute_msg(numeric(0), 25))
})

test_that("compute_mrg works correctly", {
  # Single timepoint returns default

  expect_equal(compute_mrg(c(10), c(3), 25), 0.1)

  # Standard case
  mrg <- compute_mrg(c(5, 15, 20), c(3, 5, 7), 25)
  expect_true(mrg > 0)
  expect_true(is.numeric(mrg))

  # Zero germination throughout
  mrg0 <- compute_mrg(c(0, 0, 0), c(3, 5, 7), 25)
  expect_equal(mrg0, 0)

  # Errors

  expect_error(compute_mrg(c(5, 15), c(3), 25))
  expect_error(compute_mrg(c(5, 15), c(5, 3), 25))  # non-increasing time
})

test_that("compute_cmtg works correctly", {
  # Rapid germination: already past 50% at day 3
  cmtg_fast <- compute_cmtg(c(20, 23, 25), c(3, 5, 7), 25)
  expect_true(cmtg_fast > 0 && cmtg_fast <= 1)

  # Slow germination
  cmtg_slow <- compute_cmtg(c(2, 8, 20), c(3, 5, 7), 25)
  expect_true(cmtg_slow > 0 && cmtg_slow <= 1)

  # Fast should be >= slow

  expect_true(cmtg_fast >= cmtg_slow)

  # Zero germination
  cmtg_zero <- compute_cmtg(c(0, 0, 0), c(3, 5, 7), 25)
  expect_true(is.numeric(cmtg_zero))

  # Errors
  expect_error(compute_cmtg(c(5), c(3, 5), 25))
})

test_that("compute_rvs works correctly", {
  expect_equal(compute_rvs(18, 25), 0.72)
  expect_equal(compute_rvs(0, 25), 0)
  expect_equal(compute_rvs(25, 25), 1.0)
  expect_equal(compute_rvs(NULL, 25), 0)
  expect_equal(compute_rvs(NA, 25), 0)
  expect_error(compute_rvs(30, 25))
  expect_error(compute_rvs(-1, 25))
})
