% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-logLik.R
\name{PCBN_PDF}
\alias{PCBN_PDF}
\title{PDF of a PCBN model}
\usage{
PCBN_PDF(PCBN, newdata)
}
\arguments{
\item{PCBN}{PCBN object}

\item{newdata}{new data on which the PDF should be computed}
}
\value{
the probability density at newdata.
}
\description{
This function computes the Probability Density Function of a PCBN model.
}
\details{
This is a wrapper to \code{\link{logLik.PCBN}}.
}
\examples{
DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)
tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

mydata = PCBN_sim(my_PCBN, N = 10)

PCBN_PDF(my_PCBN, mydata)

}
