% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{B_sets_are_increasing}
\alias{B_sets_are_increasing}
\title{Checks if the B-sets for a particular node form an increasing sequence.}
\usage{
B_sets_are_increasing(B_sets)
}
\arguments{
\item{B_sets}{a boolean matrix with \code{(2 + length(children))}
columns and \code{length(parents)} rows.
They are assumed to be sorted in increasing order of row sums,
i.e. by increasing order of set cardinality.
Typically, this will be the output of \code{find_B_sets_v}.}
}
\value{
\code{TRUE} if the B-sets form an ordered sequence,
otherwise returns \code{FALSE}.
}
\description{
Checks if the B-sets for a particular node form an increasing sequence.
}
\examples{
B_sets = matrix(c(FALSE, FALSE, FALSE, FALSE,
                  TRUE , FALSE, FALSE, FALSE,
                  TRUE , TRUE , FALSE, FALSE,
                  TRUE , TRUE , TRUE ,  TRUE),
                nrow = 4, byrow = TRUE)

B_sets_are_increasing(B_sets)

B_sets = matrix(c(FALSE, FALSE, FALSE, FALSE,
                  TRUE , FALSE, TRUE , FALSE,
                  TRUE , TRUE , FALSE, FALSE,
                  TRUE , TRUE , TRUE ,  TRUE),
                nrow = 4, byrow = TRUE)

B_sets_are_increasing(B_sets)

}
