% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseObservationPeriod.R
\name{summariseObservationPeriod}
\alias{summariseObservationPeriod}
\title{Summarise the observation period table getting some overall statistics in a
summarised_result object}
\usage{
summariseObservationPeriod(
  cdm,
  estimates = c("mean", "sd", "min", "q05", "q25", "median", "q75", "q95", "max",
    "density"),
  missingData = TRUE,
  quality = TRUE,
  byOrdinal = TRUE,
  ageGroup = NULL,
  sex = FALSE,
  dateRange = NULL,
  observationPeriod = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{estimates}{Estimates to summarise the variables of interest (
\verb{Records per person}, \verb{Duration in days} and
\verb{Days to next observation period}).}

\item{missingData}{Logical. If \code{TRUE}, includes a summary of missing data for
relevant fields.}

\item{quality}{Logical. If \code{TRUE}, performs basic data quality checks,
including:
\itemize{
\item Number of subjects not included in person table.
\item Number of records with end date before start date.
\item Number of records with start date before the person's birth date.
}}

\item{byOrdinal}{Boolean variable. Whether to stratify by the ordinal
observation period (e.g., 1st, 2nd, etc.) (TRUE) or simply analyze overall
data (FALSE)}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}

\item{observationPeriod}{deprecated.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
Summarise the observation period table getting some overall statistics in a
summarised_result object
}
\examples{
\donttest{
library(OmopSketch)
library(dplyr, warn.conflicts = FALSE)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseObservationPeriod(cdm = cdm)

tableObservationPeriod(result = result)

plotObservationPeriod(
  result = result,
  variableName = "Duration in days",
  plotType = "boxplot"
)

cdmDisconnect(cdm = cdm)
}

}
