% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_biopsy.R
\name{classify_biopsy}
\alias{classify_biopsy}
\title{Determine the type of biopsy from identifiers}
\usage{
classify_biopsy(biopsy_numbers)
}
\arguments{
\item{biopsy_numbers}{Character vector. Identifiers of biopsies to classify.}
}
\value{
A character vector representing the type of Sample type:
         1, biopsy
         2, aspiration
         3, cytology
}
\description{
This function analyzes biopsy identifiers and categorizes them into specific
types based on a defined rule.
}
\examples{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file

NB_values <- c()
NB_values <- extract_intermediate_values(NB_values, lines, "biopsia:")

biopsies_identifiers <- classify_biopsy(NB_values)

}
