\name{bladder}
\alias{bladder}
\docType{data}

\title{Bladder Cancer Recurrence Times}

\description{
Recurrence times (in months) for bladder cancer patients, reported in
Lee and Wang (2003). The dataset contains observed survival times without
censoring information and is commonly used in survival analysis examples.
}

\usage{
data(bladder)
}

\format{
A numeric vector giving recurrence times (in months) for bladder cancer
patients. A total of 128 observations are included.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 128 observed recurrence times (in months), each
corresponding to a single bladder cancer patient. Each value represents the
time from treatment or diagnosis to documented cancer recurrence. The dataset
is commonly used in survival analysis and biostatistics to illustrate
time-to-event modeling, including Kaplan--Meier estimation, hazard rate
analysis, accelerated failure-time (AFT) models, and parametric survival
distributions.
}

\details{
These recurrence times are widely used in demonstrations of survival analysis
methods, including Kaplan--Meier estimation, hazard rate modelling,
accelerated failure-time (AFT) models, and parametric distribution fitting.
The dataset originally appears in Lee and Wang's \emph{Statistical Methods for
Survival Data Analysis} (3rd ed.), a standard reference text in biostatistics.

Note: The dataset provided here contains recurrence times only and does not
include censoring indicators or covariates found in extended versions of the
bladder cancer data.
}

\references{
Lee, E. T., & Wang, J. W. (2003).
\emph{Statistical Methods for Survival Data Analysis} (3rd ed.).
Wiley, New York.
}

\examples{
data(bladder)

# Basic summary
summary(bladder)

# Histogram of recurrence times
hist(
  bladder,
  main = "Bladder Cancer Recurrence Times",
  xlab = "Time (months)"
)
}

\keyword{datasets}
