% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvEEP.r
\name{InvEEP}
\alias{InvEEP}
\alias{dinv.expo.exp.pois}
\alias{pinv.expo.exp.pois}
\alias{qinv.expo.exp.pois}
\alias{rinv.expo.exp.pois}
\alias{hinv.expo.exp.pois}
\title{Inverse Exponentiated Exponential Poisson (IEEP) Distribution}
\usage{
dinv.expo.exp.pois(x, alpha, beta, lambda, log = FALSE)
pinv.expo.exp.pois(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qinv.expo.exp.pois(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rinv.expo.exp.pois(n, alpha, beta, lambda)
hinv.expo.exp.pois(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.expo.exp.pois}: numeric vector of (log-)densities
  \item \code{pinv.expo.exp.pois}: numeric vector of probabilities
  \item \code{qinv.expo.exp.pois}: numeric vector of quantiles
  \item \code{rinv.expo.exp.pois}: numeric vector of random variates
  \item \code{hinv.expo.exp.pois}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Exponentiated Exponential Poisson distribution.
}
\details{
The Inverse Exponentiated Exponential Poisson distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Inverse Exponentiated Exponential Poisson distribution has CDF:

\deqn{
F(x;\,\alpha,\beta,\lambda) = 1 - \frac{1}{{\left( {1 - {e^{ - \lambda }}} \right)}}
\left[ {1 - \exp \left\{ { - \lambda {{\left( {1 - {e^{ - \beta /x}}} \right)}^
\alpha }} \right\}} \right]\,; \quad x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dinv.expo.exp.pois()} — Density function
  \item \code{pinv.expo.exp.pois()} — Distribution function
  \item \code{qinv.expo.exp.pois()} — Quantile function
  \item \code{rinv.expo.exp.pois()} — Random generation
  \item \code{hinv.expo.exp.pois()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dinv.expo.exp.pois(x, 1.5, 0.8, 2)
pinv.expo.exp.pois(x, 1.5, 0.8, 2)
qinv.expo.exp.pois(0.5, 1.5, 0.8, 2)
rinv.expo.exp.pois(10, 1.5, 0.8, 2)
hinv.expo.exp.pois(x, 1.5, 0.8, 2)

#Data
x <- conductors
#ML Estimates    
params = list(alpha =40.5895, beta=22.7519, lambda=2.9979)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.expo.exp.pois, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.expo.exp.pois, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
res <- gofic(x, params = params, dfun = dinv.expo.exp.pois, 
             pfun = pinv.expo.exp.pois, plot=FALSE)
print.gofic(res)

}
\references{
Ristic, M.M., & Nadarajah, S.(2014). 
A New Lifetime Distribution. 
\emph{Journal of Statistical Computation and Simulation}, \bold{84(1)}, 135--150. 
\doi{10.1080/00949655.2012.697163}

Telee, L. B. S., & Kumar, V. (2023). 
Inverse Exponentiated Exponential Poisson Distribution with Theory and 
Applications. \emph{International Journal of Engineering Science Technologies}, 
\bold{7(5)}, 17--36.  \doi{10.29121/IJOEST.v7.i5.2023.535}
}
