% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{VAR}
\alias{VAR}
\title{Estimates a standard VAR(1)}
\usage{
VAR(RiskFactors, VARtype, Bcon_Mat = NULL)
}
\arguments{
\item{RiskFactors}{numeric matrix (\code{K x Td}). Time series of risk factors.}

\item{VARtype}{character. Permissible choices: "unconstrained" or "constrained".}

\item{Bcon_Mat}{matrix (\code{K x K + 1}). Constraints matrix (includes intercept). Entries containing NAs are treated as free parameters. Default is NULL.}
}
\value{
list. Contains:
  \itemize{
  \item intercept (K x 1)
  \item feedback matrix (K x K)
  \item variance-covariance matrix (K x K) of a VAR(1)
}
}
\description{
Estimates a standard VAR(1)
}
\section{General Notation}{

\itemize{
  \item \code{Td}: model time series dimension
  \item \code{N}: number of country-specific spanned factors
  \item \code{K}: total number of risk factors
}
}

\examples{
data(RiskFacFull)
# Example 1: unconstrained case
VAR_para1 <- VAR(RiskFacFull, VARtype = "unconstrained")

# Example 2: constrained case
K <- nrow(RiskFacFull)
Bcon_Mat <- matrix(0, nrow = K, ncol = K + 1)
Bcon_Mat[, 1:3] <- NaN
VAR_para2 <- VAR(RiskFacFull, VARtype = "constrained", Bcon_Mat)

}
