# Clean environment and load libraries
rm(list = ls())  # Clear environment to avoid conflicts

# Source files
library(MixStable)

# 📊 Generate sample data
set.seed(123)
x_sample <- rnorm(100)
u_value <- 2.0
bn_value <- 0.5

# 🧮 Compute real and imaginary parts of the integral
real_part <- Int_Re(u_value, mean(x_sample), bn_value)
imag_part <- Int_Im(u_value, mean(x_sample), bn_value)

# 📋 Print results
cat(sprintf("Real Part of Integral: %.6f\n", real_part))
cat(sprintf("Imaginary Part of Integral: %.6f\n", imag_part))
