% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_palette.R
\name{update_palette}
\alias{update_palette}
\title{Update community and layer color palettes in MixMashNet objects}
\usage{
update_palette(fit, community_colors = NULL, layer_colors = NULL)
}
\arguments{
\item{fit}{An object of class \code{mixMN_fit} or \code{multimixMN_fit}.}

\item{community_colors}{Optional named character vector specifying new colors
for communities. Names must correspond to existing community labels
(as stored in \code{communities$palette}). Missing names are ignored.}

\item{layer_colors}{Optional named character vector specifying new colors for
layers. Names must correspond to existing layer names
(as stored in \code{layers$palette}). Only applicable to
\code{multimixMN_fit} objects.}
}
\value{
The input object \code{fit}, with updated community and/or layer palettes.
}
\description{
Updates the color palettes associated with communities and/or layers in
\code{mixMN_fit} and \code{multimixMN_fit} objects. The function replaces only
the colors corresponding to the provided names, leaving all other colors
unchanged.

If colors are provided for names that do not exist in the object (e.g.,
unknown community labels or layer names), a warning is issued and those entries
are ignored. If some communities or layers are not specified, their original
colors are preserved.
}
\details{
For \code{mixMN_fit} objects, community colors are updated in
\code{fit$communities$palette}.

For \code{multimixMN_fit} objects, community colors are updated separately
within each layer (i.e., in \code{fit$layer_fits[[L]]$communities$palette}),
while layer colors are updated in \code{fit$layers$palette}.

The function performs in-place modification of the palettes and returns the
updated object.
}
\examples{
data(bacteremia)

vars <- c("WBC", "NEU", "HGB", "PLT", "CRP")
df <- bacteremia[, vars]

fit <- mixMN(
  data = df,
  lambdaSel = "EBIC",
  reps = 0,
  seed_model = 42,
  compute_loadings = FALSE,
  progress = FALSE
)

# View original community palette
fit$communities$palette

# Update colors for communities 1 and 2
fit2 <- update_palette(
  fit,
  community_colors = c("1" = "red", "2" = "blue")
)

fit2$communities$palette

set.seed(1)
plot(fit2)

}
