% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixmashnet-summary.R
\name{summary.mixmashnet}
\alias{summary.mixmashnet}
\title{Summarize MixMashNet fits (single and multilayer) in long format}
\usage{
\method{summary}{mixmashnet}(
  object,
  what = c("intra", "inter"),
  statistics = NULL,
  layer = NULL,
  pairs = NULL,
  digits = 3,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"mixmashnet"} returned by
\code{mixMN()} or \code{multimixMN()}.}

\item{what}{Character string indicating which part of the model to summarize:
\itemize{
  \item \code{"intra"}: intralayer quantities (node-level indices and/or
    intralayer edges);
  \item \code{"inter"}: interlayer quantities (node-level indices on the
    interlayer-only graph and/or cross-layer edges; multilayer fits only).
}}

\item{statistics}{Character vector specifying which statistics to include.
  For \code{what = "intra"}, valid values are:
  \code{c("edges",
         "strength", "expected_influence", "closeness", "betweenness",
         "bridge_strength", "bridge_closeness", "bridge_betweenness",
         "bridge_ei1", "bridge_ei2",
         "bridge_strength_excluded", "bridge_betweenness_excluded",
         "bridge_closeness_excluded", "bridge_ei1_excluded",
         "bridge_ei2_excluded")}.

  For \code{what = "inter"}, valid values are:
  \code{c("edges", "strength", "expected_influence", "closeness",
         "betweenness")}.

  If \code{statistics = NULL}, then:
  \itemize{
    \item for \code{what = "intra"}, all available intralayer statistics
      (including \code{"edges"}) are returned;
    \item for \code{what = "inter"}, all available interlayer statistics
      (including \code{"edges"}) are returned.
  }}

\item{layer}{Optional character vector of layer names to subset. Used for
\code{what = "intra"} in multilayer fits. Ignored for single layer fits.}

\item{pairs}{Optional character vector of layer-pair names (e.g.
\code{"bio_dis"}) used for \code{what = "inter"} when summarizing
interlayer edges. If \code{NULL}, all available layer pairs are included.
For interlayer node indices, \code{pairs} can be used to restrict the
summary to nodes belonging to one of the layers in the given pair.}

\item{digits}{Number of digits to round numeric summaries.}

\item{...}{Not used (for S3 compatibility).}
}
\value{
A list (class \code{"summary.mixmashnet"}) with up to four data frames
(\code{$index}, \code{$edges}, \code{$interlayer_index},
\code{$interlayer_edges}) and the quantile region used to compute the
bootstrap quantile regions (\code{$quantile_level}).

  Depending on \code{what} and \code{statistics}, some of these elements may
  be \code{NULL}.
}
\description{
Summarizes fitted MixMashNet objects (single and multilayer).
The summary includes the original estimates and, when available, bootstrap
means, standard errors, and quantile regions.
}
