% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_bridge_communities.R
\name{find_bridge_communities}
\alias{find_bridge_communities}
\title{Bridge profiles of a node across communities}
\usage{
find_bridge_communities(fit, node)
}
\arguments{
\item{fit}{An object of class \code{mixMN_fit}.}

\item{node}{Character scalar: node of interest; must belong to
\code{fit$graph$keep_nodes_graph}.}
}
\value{
An object of class \code{"bridge_profiles"} (a named list) with the
  following components:
\describe{
  \item{\code{bridge_strength}}{Bridge strength. List with \code{overall}, the total
    value across all other communities, and \code{by_comm}, a tibble with
    community-specific contributions (\code{community}, \code{sum_abs_w}).}
  \item{\code{bridge_ei1}}{Bridge expected influence (order 1). List with
    \code{overall} and \code{by_comm} (\code{community}, \code{sum_signed_w}).}
  \item{\code{bridge_ei2}}{Bridge expected influence (order 2). List with
    \code{overall} and \code{by_comm} (\code{community}, \code{sum_signed_w2}).}
  \item{\code{bridge_closeness}}{Bridge closeness. List with \code{overall} and
    \code{by_comm} (\code{community}, \code{inv_mean_dist}).}
  \item{\code{bridge_betweenness}}{Bridge betweenness. List with \code{overall} and
    \code{by_pair}, a tibble with contributions by community pair
    (\code{Ci}, \code{Cj}, \code{hits}).}
}
}
\description{
Identifies which communities contribute most to the bridge role of a
given node, by decomposing its bridge connectivity into community-specific
contributions, excluding its own community when assigned. The function is
designed as an interpretative companion to \code{bridge_metrics()} and
\code{bridge_metrics_excluded()}, providing the components underlying
the corresponding overall bridge indices.
}
\details{
Bridge connectivity is summarized using five complementary profiles: bridge
strength, bridge EI1, bridge EI2, bridge closeness, and bridge betweenness.

Notes:
\itemize{
  \item Bridge profiles are computed using only connections from the focal node to
        nodes in communities different from its own. If the focal node is not
        assigned to any community, i.e. excluded, connections to all assigned nodes in
        communities are considered.
  \item Bridge betweenness is computed by counting all shortest paths between
        pairs of nodes in different communities that pass through the focal
        node as an intermediate vertex. When multiple shortest paths exist,
        each path is counted separately.
}
}
