% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_scores.R
\name{community_scores}
\alias{community_scores}
\title{Compute community scores from a fitted MixMashNet model}
\usage{
community_scores(
  fit,
  data = NULL,
  layer = NULL,
  scale = TRUE,
  quantile_level = NULL,
  return_quantile_region = FALSE,
  na_action = c("stop", "omit")
)
}
\arguments{
\item{fit}{A fitted object of class \code{c("mixmashnet","mixMN_fit", "multimixMN_fit")}
returned by \code{mixMN()} or \code{multimixMN()}.}

\item{data}{Optional data.frame with variables in columns. If
\code{NULL}, uses \code{fit$model$data}. Errors if both are \code{NULL}.}

\item{layer}{Optional. If fit is a multimixMN_fit, specify which layer to score (name or index).
If NULL, scores are computed for all layers and returned as a named list.}

\item{scale}{Logical; if \code{TRUE} (default), z-standardize variables used
for scoring, using the mean/SD computed from the dataset used for scoring.}

\item{quantile_level}{Optional numeric from 0 to 1, e.g. 0.95 or 0.99. If provided,
percentile bootstrap quantile regions are computed for community scores
(requires \code{fit$community_loadings$boot}).}

\item{return_quantile_region}{Logical; if \code{TRUE}, return quantile regions.}

\item{na_action}{Character. How to handle missing values in the scoring data:
\code{"stop"} (default) stops if any missing value is present in the
required variables; \code{"omit"} computes scores using row-wise omission
within each community (i.e., uses available variables only, re-normalizing
weights within community for that row).}
}
\value{
A list with class \code{c("mixmashnet","community_scores")} containing:
\describe{
  \item{\code{call}}{The matched call.}
  \item{\code{settings}}{List with \code{scale}, \code{quantile_level}, and \code{na_action}.}
  \item{\code{ids}}{Character vector of subject IDs (rownames of \code{data}).}
  \item{\code{communities}}{Character vector of community score names.}
  \item{\code{scores}}{Numeric matrix of scores (n × K).}
  \item{\code{quantile_region}}{If requested and available, a list with \code{lower} and \code{upper}
    matrices (n × K) for percentile bootstrap quantile regions; otherwise \code{NULL}.}
  \item{\code{details}}{List containing \code{nodes_used}, \code{loadings_true},
    \code{loadings_boot_available}, and scaling parameters (\code{center}, \code{scale}).}
}
If \code{fit} is a \code{mixMN_fit} (or a \code{multimixMN_fit} with \code{layer} specified),
returns a \code{c("mixmashnet","community_scores")} object.
If \code{fit} is a \code{multimixMN_fit} and \code{layer = NULL}, returns a named list
of \code{community_scores} objects (one per layer).
}
\description{
Computes subject-level community scores. Community scores are obtained as
weighted sums of the variables belonging to each detected community, where
weights correspond to the standardized community loadings estimated via
\code{EGAnet::net.loads} and stored in the fitted \code{mixMN_fit} object.
Scores are computed using the dataset provided via the \code{data} argument.
If \code{data = NULL}, the original dataset used to fit the model
(\code{fit$model$data}) is used by default.
Optionally, percentile bootstrap quantile regions for the community
scores can be computed if bootstrap community loadings are available in
\code{fit$community_loadings$boot}.
Community scores are only available if community loadings were computed
in the fitted model. This requires that all variables in the community
subgraph are of MGM type Gaussian (\code{"g"}), Poisson (\code{"p"}), or
binary categorical (\code{"c"} with \code{level == 2}).
}
\details{
The function requires that \code{fit$community_loadings$true} exists and that
the input \code{data} contains all required variables in
\code{fit$community_loadings$nodes}. It errors otherwise.
}
\examples{
data(bacteremia)

vars <- c("WBC", "NEU", "HGB", "PLT", "CRP")
df <- bacteremia[, vars]

fit <- mixMN(
  data = df,
  lambdaSel = "EBIC",
  reps = 0,
  seed_model = 42,
  compute_loadings = TRUE,
  progress = FALSE,
  save_data = TRUE
)

# Compute community scores on the original data
scores <- community_scores(fit)
summary(scores)

}
\references{
Christensen, A. P., Golino, H., Abad, F. J., & Garrido, L. E. (2025).
Revised network loadings. \emph{Behavior Research Methods}, 57(4), 114.
\doi{10.3758/s13428-025-02640-3}
}
