% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridge_metrics_excluded.R
\name{bridge_metrics_excluded}
\alias{bridge_metrics_excluded}
\title{Bridge metrics for nodes excluded from communities}
\usage{
bridge_metrics_excluded(g, membership)
}
\arguments{
\item{g}{An igraph object with edge attribute \code{weight}.}

\item{membership}{Named vector/factor of community labels for a subset of nodes (names must match \code{V(g)$name}).
Nodes not present here are treated as excluded.}
}
\value{
A data.frame with columns: \code{node}, \code{bridge_strength}, \code{bridge_closeness}, \code{bridge_betweenness},
        \code{bridge_ei1}, \code{bridge_ei2}.
}
\description{
Computes bridge centrality measures for nodes that are not assigned to any
community.
This function is used internally by \code{mixMN()} and \code{multimixMN()}.
For these excluded nodes, the function computes bridge strength, bridge
closeness, bridge betweenness, and bridge expected influence of order one and
two (EI1 and EI2), quantifying their role in connecting nodes across different
communities.
}
\details{
Bridge betweenness excluded and closeness excluded are computed on the positive-weight subgraph
only, with weights converted to distances as \eqn{d = 1/w}.
}
\references{
Jones, P. J. (2025). \pkg{networktools}: Tools for identifying important nodes
in networks. R package version 1.6.1.
\url{https://github.com/paytonjjones/networktools}
}
