% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridge_metrics.R
\name{bridge_metrics}
\alias{bridge_metrics}
\title{Bridge metrics for nodes across communities}
\usage{
bridge_metrics(g, membership)
}
\arguments{
\item{g}{An igraph object with edge attribute \code{weight}.}

\item{membership}{Named vector/factor of community labels for a subset of nodes (names must match \code{V(g)$name}).}
}
\value{
A data.frame with columns: \code{node}, \code{community}, \code{bridge_strength}, \code{bridge_ei1},
       \code{bridge_ei2}, \code{bridge_betweenness}, \code{bridge_closeness}.
}
\description{
Computes bridge centrality measures for nodes with an assigned community.
This function is used internally by \code{mixMN()} and \code{multimixMN()}.
Specifically, the function computes bridge strength as the sum of absolute
edge weights connecting a node to nodes in other communities; bridge expected
influence of order one (EI1) as the signed sum of direct connections to nodes
in other communities; bridge expected influence of order two (EI2) as the
signed influence that propagates indirectly to nodes in other communities
via one intermediate neighbor (i.e., through paths of length two);
bridge betweenness as the number of times a node lies on shortest paths
between nodes belonging to different communities; and bridge closeness as the
inverse of the mean shortest-path distance to nodes in other communities.
}
\details{
Bridge betweenness and closeness are computed on the positive-weight subgraph
only, with weights converted to distances as \eqn{d = 1/w}.
}
\references{
Jones, P. J. (2025). \pkg{networktools}: Tools for identifying important nodes
in networks. R package version 1.6.1.
\url{https://github.com/paytonjjones/networktools}

Jones, P. J., Ma, R., & McNally, R. J. (2021).
Bridge Centrality: A Network Approach to Understanding Comorbidity.
\emph{Multivariate Behavioral Research}, 56(2), 353–367.
\doi{10.1080/00273171.2019.1614898}
}
