% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixFrac.R
\name{generate_ff}
\alias{generate_ff}
\title{Generate Mixed-Level or Regular Fractional Factorial Designs}
\usage{
generate_ff(
  levels_spec,
  n_runs,
  max_iter = 100,
  a = 1,
  b = 1,
  max_int_order = 3,
  alias_min_abs_corr = 0.9,
  tf = FALSE,
  parts = c(1, 2, 3),
  verbose = TRUE
)
}
\arguments{
\item{levels_spec}{A numeric vector such as \code{c(2,3,4)} (levels per factor),
or a named list of level labels (e.g. \code{list(A = 1:2, B = 1:3, C = 1:4)}).}

\item{n_runs}{Number of experimental runs required.}

\item{max_iter}{Maximum number of iterations for coordinate exchange or
unique-subset improvement (default: \code{100}).}

\item{a}{Weight for the J2 near-orthogonality criterion.}

\item{b}{Weight for the Hhat balance criterion.}

\item{max_int_order}{Highest-order interaction used when building model
matrices for alias calculations. Default is \code{3}.}

\item{alias_min_abs_corr}{Minimum absolute correlation required for a pair of
model terms to appear in the strong confounding summary table.}

\item{tf}{Logical. When \code{TRUE}, computes a trend-free run order (Part 3)
based on deterministic pairwise swapping.}

\item{parts}{Integer vector selecting which sections to print:
\itemize{
\item \code{1} -> Part 1: Design
\item \code{2} -> Part 2: Properties & alias
\item \code{3} -> Part 3: Trend-free order
}

To print all: \code{parts = c(1,2,3)} (default).}

\item{verbose}{Logical. When \code{TRUE}, prints results. When \code{FALSE}, performs
all computations silently.}
}
\value{
A list containing:
\itemize{
\item \code{design_int} -> integer-coded design
\item \code{design_labels} -> decoded factor levels
\item \code{level_maps} -> internal mapping of coded levels
\item \code{Hhat} -> balance measure
\item \code{J2hat} -> near-orthogonality measure
\item \code{GBM} -> general balance metric
\item \code{gbm_resolution} -> smallest order with imbalance
\item \code{model_matrix} -> model matrix with interactions
\item \code{corr_matrix} -> correlation matrix
\item \code{alias_chains} -> alias chain structure
\item \code{alias_summary} -> strong confounding pairs
\item \code{trend_free_result} -> (if \code{tf = TRUE}) run order, reordered design,
and final trend objective
}

Returned invisibly unless assigned.
}
\description{
\code{generate_ff()} constructs mixed-level fractional factorial designs or,
when all factors share the same number of levels \eqn{s}, automatically
searches for a regular \eqn{s^{k-p}} fractional factorial using generator
relations.

#' The function performs:
\itemize{
\item \strong{Part 1:} Design construction (regular or mixed-level)
\item \strong{Part 2:} Design diagnostics: balance (Hhat), J2, GBM,
alias chains, and strong confounding summary
\item \strong{Part 3 (optional):} Deterministic trend-free run order based on
Coster (1993)
}

Output printing can be controlled via the \code{parts} argument.
}
\details{
\subsection{Automatic Regular Fractional Factorial Detection}{

When all factors have the same number of levels \eqn{s}, and when
\eqn{n\_runs = s^{k-p}}, the function attempts to find a regular
\eqn{s^{k-p}} fraction via a heuristic generator search inspired by Guo et al.
(2007). The objective minimized is:

The objective function minimized is
\code{Z = a * J2 + b * Hhat}.

If no acceptable generator set is found, the algorithm reverts to a mixed-level
design strategy.
}

\subsection{Mixed-Level Fractional Factorials}{

Mixed-level designs are constructed using the Pantoja-Pacheco et al. (2021)
NONBPA skeleton for nonmultiple levels, followed by a Guo-style coordinate
exchange improvement on the \eqn{Z}-criterion.
}

\subsection{Alias Structure (Rios-Lira et al., 2021)}{

Alias relationships are computed from the correlation matrix of the model
matrix (main effects + interactions). Chains are built by selecting the pair
of terms with the highest absolute correlation, choosing the lower-order term
as the chain leader.
}

\subsection{Trend-Free Run Order (Coster, 1993)}{

When \code{tf = TRUE}, a deterministic pairwise-swap algorithm produces a run order
orthogonal to polynomial time trends (linear by default).
}
}
\examples{
\donttest{

# Mixed-level design (2 x 3 x 4), 12 runs, all parts printed
generate_ff(c(2,3,4), 12, tf = TRUE)

# Only Part 1 (design)
generate_ff(c(2,3,4), 12, parts = 1, tf = FALSE)

# Parts 1 and 2 only
generate_ff(c(2,3,4), 12, parts = c(1,2), tf = FALSE)

# Only Part 3 (trend-free run order)
generate_ff(c(2,3,4), 12, parts = 3, tf = TRUE)

}
}
\references{
Guo, Y., Simpson, J. R., & Pignatiello, J. J. (2007).
\emph{Construction of Efficient Mixed-Level Fractional Factorial Designs.}
Journal of Quality Technology, 39(3), 241-257.
\doi{10.1080/00224065.2007.11917691}

Pantoja-Pacheco, Y. V. et al. (2021).
\emph{One Note for Fractionation and Increase for Mixed-Level Designs When the Levels Are Not Multiple.}
Mathematics, 9(13), 1455.
\doi{10.3390/math9131455}

Rios-Lira, A. J. et al. (2021).
\emph{Alias Structures and Sequential Experimentation for Mixed-Level Designs.}
Mathematics, 9(23), 3053.
\doi{10.3390/math9233053}

Coster, D. C. (1993).
\emph{Trend-Free Run Orders of Mixed-Level Fractional Factorial Designs.}
Annals of Statistics, 21(4), 2072-2086.
\doi{10.1214/aos/1176349410}
}
