% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mosaSTRS.R
\name{summary.mosaSTRS}
\alias{summary.mosaSTRS}
\title{Summary a mosaSTRS object}
\usage{
\method{summary}{mosaSTRS}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{mosaSTRS},
representing the results of the function \code{mosallocSTRS()}. This
can also be a list of \code{mosaSTRS} objects.}

\item{...}{some methods for this generic require additional arguments.
None are used in this method.}
}
\value{
Either a \code{summary.mosaSTRS} object for a \code{mosaSTRS}
object or a list of \code{summary.mosaSTRS} objects for a list of
\code{mosaSTRS} objects. A \code{summary.mosaSTRS} object is a list
containing the following components:

\code{$vname} Name of \code{object}.

\code{$sense}
Sense of optimization; \code{max precision} or \code{min_cost}.

\code{$method}
The method used weighted sum scalarization (WSS) or weighted Chebyshev
minimization (WCM).

\code{$objout}
A data frame corresponding to the objectives, including the values, the
sensitivity, the weights and the RSE.

\code{$precision}
A data frame corresponding to the precision constraints.

\code{$cost}
A data frame corresponding to the cost constraints.

\code{$n_opt}
A vector of optimal sample sizes w.r.t the \code{weights}.
}
\description{
Summary-function for class \code{mosaSTRS}
}
