% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dimension_reduction.R
\name{Dimension_reduction}
\alias{Dimension_reduction}
\title{Dimension_reduction: PCA, PCOA, and NMDS Analysis}
\usage{
Dimension_reduction(inputframe, group, format)
}
\arguments{
\item{inputframe}{An OTU/gene/taxa table with all numeric variables and no NA/NAN/inf values.}

\item{group}{Group information with the sample order the same as in inputframe.}

\item{format}{The format of analysis: 1 for PCA, 2 for PCOA, 3 for NMDS.}
}
\value{
A list containing data frames and other statistics for dimension reduction analysis.
}
\description{
Performs dimension reduction analysis using PCA, PCOA, or NMDS.
}
\note{
Inputframe should be a numeric matrix without NA/NAN/inf values.

The row names of inputframe should be set as OTU/gene/taxa annotations for further analysis.

The results are combined into a list for output. Use \code{as.data.frame(result[[1]])} to extract the data frame, and \verb{$result$} to extract other statistics. See examples for details.
}
\examples{
### Data preparation ###
data(testotu)
rownames(testotu) <- testotu[, 1]
inputotu <- testotu[, -c(1, ncol(testotu))]
head(inputotu)

groupinformation1 <- data.frame(
  group = c(rep("a", 10), rep("b", 10)),
  factor1 = rnorm(10),
  factor2 = rnorm(mean = 100, 10)
)

### PCA ###
PCAresult <- Dimension_reduction(inputotu, groupinformation1, 1)
PCAframe <- PCAresult$outframe   # Extract data for visualization
head(PCAresult$data.pca$rotation,5)  # OTU coordinates

### PCOA ###
PCOAresult <- Dimension_reduction(inputotu, groupinformation1, 2)
PCOAframe <- PCOAresult$outframe  # Extract data for visualization
head(PCOAresult$PCOA$values,2)  # Explanation of first two axis

### NMDS ###
NMDSresult <- Dimension_reduction(inputotu, groupinformation1, 3)
NMDSframe <- NMDSresult$outframe  # Extract data for visualization
# Here we got a warning of `stress is (nearly) zero: you may have insufficient data`,
# so make sure you have sufficient data for NMDS
print(NMDSresult$NMDSstat$stress)  # Extract stress of NMDS
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
