% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimp.mat.bin.R
\name{pimp.mat.bin}
\alias{pimp.mat.bin}
\title{Predictor Importance Matrix – Classification}
\usage{
pimp.mat.bin(pimps.out, testdata)
}
\arguments{
\item{pimps.out}{R object containing \code{vec.primes}, \code{tmp.mat}, \code{vec.pimpvars}, and \code{list.pimps}.}

\item{testdata}{Data frame or matrix of out-of-bag (OOB) samples.}
}
\value{
A list with the following components:
\describe{
\item{pimp.names}{Vector of predictor names.}
\item{pimp.datamat}{Logical matrix indicating which predictors (columns) are used in each interaction (rows).}
}
}
\description{
Internal function called by \code{\link{pimp.import}} to construct a binary/logical matrix
representing which predictors (columns) are used in each interaction (rows) of a sample.
}
\details{
\strong{Note:} For regression models, see \code{\link{pimp.mat.nonbin}} which accommodates complements of logic trees.
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers.
\emph{Bioinformatics}. 2010;26(17):2183–2189. \doi{10.1093/bioinformatics/btq354}
}
\seealso{
\code{\link{pimp.import}}
}
\author{
Bethany J. Wolf \email{wolfb@musc.edu}
}
\keyword{internal}
