% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msbatchAnnotationFunctions.R
\name{annotatemsbatch}
\alias{annotatemsbatch}
\title{Lipid annotation for an msbatch}
\usage{
annotatemsbatch(
  msbatch,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 5,
  coelCutoff = 0.8,
  lipidClassesPos = c("MG", "LPC", "LPE", "PC", "PCo", "PCp", "PE", "PEo", "PEp", "PG",
    "PI", "Sph", "SphP", "Cer", "CerP", "AcylCer", "SM", "Carnitines", "CE", "DG", "TG"),
  lipidClassesNeg = c("FA", "FAHFA", "LPC", "LPE", "LPG", "LPI", "LPS", "PC", "PCo",
    "PCp", "PE", "PEo", "PEp", "PG", "PI", "PS", "Sph", "SphP", "Cer", "CerP", "AcylCer",
    "SM", "CL", "BA"),
  dbs,
  simplifyAnnotations = FALSE,
  parallel = FALSE,
  ncores,
  global_gb = getOption("LipidMS.future.globals.maxSizeGB", 24)
)
}
\arguments{
\item{msbatch}{msbatch}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 5 seconds.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{lipidClassesPos}{classes of interest in ESI+.}

\item{lipidClassesNeg}{classes of interest in ESI-.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}

\item{simplifyAnnotations}{logical. If TRUE, only the most frequent id will be 
kept (recommended when only pool samples have been acquired in DIA or DDA). If 
FALSE, all annotations will be shown.}

\item{parallel}{logical.}

\item{ncores}{number of cores to be used in case parallel is TRUE.}

\item{global_gb}{numeric. Gigabytes to set as future.globals.maxSize **inside** the function.
Defaults to `getOption("LipidMS.future.globals.maxSizeGB", 24)`.}
}
\value{
msbatch
}
\description{
Summarize annotation results of an msbatch into the feature table
}
\examples{
\dontrun{
msbatch <- annotatemsbatch(msbatch)

msbatch$features
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
