% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{combineChains}
\alias{combineChains}
\title{Combine chain fragments that could belong to the same precursor.}
\usage{
combineChains(candidates, nchains, sn1, sn2, sn3, sn4)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{sn1}{list of chain fragments identified for sn1 position. Output of
\link{chainFrags}.}

\item{sn2}{list of chain fragments identified for sn2 position. Output of
\link{chainFrags}. If required.}

\item{sn3}{list of chain fragments identified for sn3 position. Output of
\link{chainFrags}. If required.}

\item{sn4}{list of chain fragments identified for sn4 position. Output of
\link{chainFrags}. If required.}
}
\value{
List of data frames with candidate chains structures.
}
\description{
It calculates combinations of chain fragments that sum up the same number of
carbons and double bounds as the precursor.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
