% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_lwfbrook90.R
\name{r_lwfbrook90}
\alias{r_lwfbrook90}
\title{Interface function to the LWF-Brook90 model}
\usage{
r_lwfbrook90(
  b90f_input,
  meteo,
  precip,
  output_log = TRUE,
  chk_input = TRUE,
  timelimit = Inf
)
}
\arguments{
\item{b90f_input}{Brook90 input list object containing all the parameters required.}

\item{meteo}{A data.table of daily meteorological data with columns: Date (dates),
global radiation (globrad, W/m²), minimum and maximum air temperature (tmin, tmax, deg C),
vapour pressure (vappress, kPa), wind speed (windspeed, m/s),
precipipitation (prec, mm), and measured flow (mesfl, mm).}

\item{precip}{An optional data.table of precipitation interval data with 6 columns: year,
month, day, interval-number (1:prec_interval), prec, mesflp.}

\item{output_log}{Logical whether to print runtime output to console.}

\item{chk_input}{Logical whether to check for NaNs in model inputs.}

\item{timelimit}{Integer for setting a time limit (in seconds, default: Inf) for the duration of the model execution.}
}
\value{
A list containing the daily and soil layer model outputs, along with
  an error code of the simulation.
}
\description{
Passes input data objects (parameters and meteorology) to the Fortran model
code and returns the results
}
