% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lopez_ruzicka.R
\name{sen_lopez_ruzicka_sym_instantaneous2}
\alias{sen_lopez_ruzicka_sym_instantaneous2}
\title{Log-scale instantaneous sensitivity via symmetrical Lopez-Ruzicka decomposition}
\usage{
sen_lopez_ruzicka_sym_instantaneous2(
  mx,
  age = 0:(length(mx) - 1),
  nx = rep(1, length(mx)),
  sex = "t",
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{Numeric vector of mortality rates (central death rates).}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex}{Character; \code{"m"} for male, \code{"f"} for female, or \code{"t"} for total.}

\item{perturb}{Numeric; a small constant determining the perturbation size (default 1e-6).}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}.
}
\description{
Estimates the instantaneous sensitivity of life expectancy using symmetric perturbations in log-scale mortality rates, based on the Lopez-Ruzicka decomposition.

Specifically, the function constructs:
\deqn{m_{x}^{1} = \exp(\log m_x + h)}
\deqn{m_{x}^{2} = \exp(\log m_x - h)}
and applies \code{sen_lopez_ruzicka_sym(mx1, mx2, ...)} to the result.
}
\details{
This method gives results equivalent to \code{sen_lopez_ruzicka_sym_instantaneous()} and \code{sen_arriaga_sym_instantaneous2()} and is preferred when working with log-transformed mortality schedules.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx <- a * exp(x * b)
s <- sen_lopez_ruzicka_sym_instantaneous2(mx, age = x)
\donttest{
plot(x, s, type = "l")
}
}
\seealso{
\code{\link{sen_lopez_ruzicka_sym}}, \code{\link{sen_lopez_ruzicka_sym_instantaneous}}, \code{\link{sen_arriaga_sym_instantaneous2}}
}
