% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding-objects.R
\name{get_nbr_comments}
\alias{get_nbr_comments}
\alias{get_nbr_comments.IssueTB}
\alias{get_nbr_comments.IssuesTB}
\title{Number of comments}
\usage{
get_nbr_comments(x)

\method{get_nbr_comments}{IssueTB}(x)

\method{get_nbr_comments}{IssuesTB}(x)
}
\arguments{
\item{x}{An object of class \code{IssueTB} or \code{IssuesTB}.}
}
\value{
An integer or an integer vector with the number of comments of the
different issues in \code{x}.
}
\description{
Number of comments of an Issue or set of issues
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "open_issues.yaml"
)
get_nbr_comments(all_issues)
get_nbr_comments(all_issues[1L, ])

}
